/***************************************************************************************************
 * File name:WIFIPort.h
 * function:XXX
 ***************************************************************************************************/
#import <Foundation/Foundation.h>
#import <stdio.h>
#import <stdlib.h>
#import <unistd.h>
#import <arpa/inet.h>
#import <sys/types.h>
#import <sys/socket.h>
#import <netdb.h>
#import <sys/ioctl.h>
#import <time.h>
#import <netinet/tcp.h>

#import "PortIO.h"

//**************************************************************************************************
//time out define
#define TIME_OUT_DEFAULT			0
#define TIME_OUT_CONNECT			(10 * 1000)
#define TIME_OUT_SMALL_DATA			(90 * 1000)	//The size of data: <= 1024bytes
#define TIME_OUT_LARGE_DATA			(90 * 1000)	//The size of data: [1024, 4096]bytes

//**************************************************************************************************
//The port type
#define NET_PORT_WIFI				0x00	//
#define NET_PORT_LAN				0x01

#define NET_PORT_COMMAND			0x00
#define NET_PORT_QUERY				0x01

//**************************************************************************************************
//Port info class
@interface PortInfoWIFI : NSObject
{	
	SInt32		NetPortType;
	NSString	*ModuleName;
	NSString	*SSID;
	NSString	*IPAddr;
	NSString	*Gateway;
	NSString	*MACAddr;
	NSString	*ExpendInfo;
}
@property (nonatomic, readwrite) SInt32 NetPortType;
@property (nonatomic, retain) NSString*	ModuleName;
@property (nonatomic, retain) NSString*	SSID;
@property (nonatomic, retain) NSString*	Gateway;
@property (nonatomic, retain) NSString*	IPAddr;
@property (nonatomic, retain) NSString*	MACAddr;
@property (nonatomic, retain) NSString*	ExpendInfo;

@end


//**************************************************************************************************
//define WIFIPort class, it is sub class of PortIO
@interface WIFIPort : PortIO

- (id)init;
- (id)init:(BOOL)n;

@end